package net.w_horse.excelpojo.xml;

import net.w_horse.excelpojo.excel.cellseeker.AbstractRepeatsSeeker;

public abstract class AbstractRepeatsSeekerFactoryBean extends
										AbstractCellSeekerFactoryBean {

	private String label;
	private String position;
	private String terminate;
	private String retrieveFrom;
	private String listClass = "java.util.ArrayList";
	private boolean margedRows = false;
	private String margedLabel;
	private String succeedFields = "";

	@Override
	public Object getObject() throws Exception {
		AbstractRepeatsSeeker seeker = (AbstractRepeatsSeeker) getObjectType().newInstance();
		seeker.setLabel(getLabel());
		seeker.setPosition(getPosition());
		seeker.setTerminate(getTerminate());
		seeker.setRetrieveFrom(getRetrieveFrom());
		seeker.setListClass(getListClass());
		seeker.setMargedRows(isMargedRows());
		seeker.setMargedLabel(getMargedLabel());
		seeker.setSucceedFields(getSucceedFields());
		seeker.setExcelPOJOBridge(getExcelPOJOBridge());
		seeker.setUse(getUse());
		seeker.setRange(getRange());

		return seeker;
	}

	public void setLabel(String label) {
		this.label = label;
	}
	public String getLabel() {
		return label;
	}
	public void setPosition(String position) {
		this.position = position;
	}
	public String getPosition() {
		return position;
	}
	public void setTerminate(String terminate) {
		this.terminate = terminate;
	}
	public String getTerminate() {
		return terminate;
	}
	public void setRetrieveFrom(String retrieveFrom) {
		this.retrieveFrom = retrieveFrom;
	}
	public String getRetrieveFrom() {
		return retrieveFrom;
	}
	public void setListClass(String listClass) {
		this.listClass = listClass;
	}
	public String getListClass() {
		return listClass;
	}
	public void setMargedRows(boolean margedRows) {
		this.margedRows = margedRows;
	}
	public boolean isMargedRows() {
		return margedRows;
	}
	public void setMargedLabel(String margedLabel) {
		this.margedLabel = margedLabel;
	}
	public String getMargedLabel() {
		return margedLabel;
	}
	public void setSucceedFields(String succeedFields) {
		this.succeedFields = succeedFields;
	}
	public String getSucceedFields() {
		return succeedFields;
	}

}
